package tcp;
/*
 * DictionaryServer.java
 *
 * Created on October 26, 2004, 1:32 PM
 */
import java.net.*;
import java.io.*;
import java.util.*;

/**
 *
 * @author  garbi
 */
public class DictionaryServer {
    private static Dictionary dico= new Hashtable();
    
    public static void main(String[] args) {
        ServerSocket connectionServer= null;
        Socket clientSession= null;
        PrintWriter out= null;
        BufferedReader in= null;
        
        dico.put("object", "objet");
        dico.put("class", "classe");
        dico.put("inheritance", "heritage");
        dico.put("distributed", "reparti");
        
        try {
            connectionServer= new ServerSocket(4443);
            clientSession = connectionServer.accept();
            System.out.println("Connection accepted\n");
            out = new PrintWriter(clientSession.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(clientSession.getInputStream()));
            String word, mot;
            
            while ( (word = in.readLine()) != null ) {
                System.out.println("Processing: " + word);
                mot= (String) dico.get(word);
                if (mot == null) mot= "sorry, no translation available for \"" + word + "\" !";
                out.println(mot);
            }
            
            out.close();
            in.close();
            connectionServer.close();
            clientSession.close();
        } catch (IOException e) {
            System.out.println(e);
            System.exit(1);
        }
    }
}
